/*----------------------------------------------------------------------------
 *      File Explorer Based on Keil RL-ARM-FlashFS
 *----------------------------------------------------------------------------
 *      Name:    main.C
 *      Purpose: File Explorer main Codes
 *----------------------------------------------------------------------------
 *      This code is part of the File Explorer Project.
 *		New Version @ digitronic.ir
 *      Copyright (c) 2011 www.ECA.ir . All rights reserved.
 *---------------------------------------------------------------------------
 * 	
 *		Programmer = Ramin Jafarpour
 *  	ramin.jafarpour@hotmail.com
 *  
 * 		WWW.ECA.ir
 *----------------------------------------------------------- */  

#include <AT91SAM7X256.h>
#include <lib_AT91SAM7X256.H>

#include <RTL.h>                 
#include <stdio.h>                   
#include <ctype.h>                
#include <string.h>                 
#include "File_Config.h"
#include "images.h"
#include <delay.h>                     
#include <gui.cpp> 
using namespace GUI; 


__task	void  task_init();
__task	void  task_main();
__task	void  task_clock();

Display disp;
char lcd_buffer[30];

unsigned char audio_buffer[512];
int audio_counter;
int audio_vs;

static char *get_entry (char *cp, char **pNext) {

  	if (cp == NULL) {  /* skip NULL pointers          */
    	*pNext = cp;
    	return (cp);
  	}
	return 0;
}


void show_logo(char *string){	
	tftlcd_fill(PURPLE);
  	tftlcd_draw_rectangle(0,0,239,15,1,BLACK);
	tftlcd_draw_rectangle(0,16,239,19,1,RED);
	tftlcd_gotoxy(5,0);
	tftlcd_putsf(string,YELLOW,BLACK,0);
}

char init_card (void) {
  	U32 retv;
  	Alert alert("File Explorer ","    ",Alert::OK);

  	if ((retv = finit (NULL)) != 0) {  // Wait until the Card is ready
    	if (retv == 1) {
			alert.SetImage(alert_image);
			strcpy(alert.Text,"SD/MMC Init Failed");
			disp.Show(alert);
			while (disp.cheak()==0) os_dly_wait(10);
			return 0;
    	}else {
			alert.SetImage(alert_image);
			strcpy(alert.Text,"SD/MMC Card is Unformatted");
			disp.Show(alert);
			while (disp.cheak()==0) os_dly_wait(10); 
			return 0;
    	}	
  	}else {
		alert.SetImage(ok_image);
		strcpy(alert.Text,"Init SD/MMC Card is OK");
		disp.Show(alert);
		for (int i=0;i<2 && disp.cheak()==0 ;i++) 
			os_dly_wait(50);  
		return 1;
	}
}

List get_dir(char *par){

   	U32 files=0,dirs=0;
   	char *mask,*next;
   	FINFO info;
	List lst(par,List::Exclusive);
  	mask = get_entry (par, &next);
  	if (mask == NULL) mask = "*.*";
  	info.fileID  = 0;  
  	while (ffind (mask,&info) == 0 && files+dirs<8) {
    	if (info.attrib & ATTR_DIRECTORY) {

			if (info.name[0]!='.') lst.Add((char *)info.name,folder_icon);
			dirs++;
		}
		else {

			if (info.name[strlen((char *)info.name)-1]=='P')  lst.Add((char *)info.name,picture_icon);	 // BMP
			else if (info.name[strlen((char *)info.name)-1]=='T')  lst.Add((char *)info.name,txt_icon);	 // TXT 
      		files++;
    	}
  	}
	return lst;
}

char show_file (char *par){

	char *fname,*next;
	FILE *f;
	int ch,index,lcd_data;
	int image_wi=0,image_hi=0;
	char image_color=0,bmp_code_index=255;
	char buffer[30];
  	show_logo(par);
    fname = get_entry (par, &next);
  	if (fname == NULL) return 0;                    
 	if ((f = fopen (fname,"r")) == NULL) return 0; // open the file for reading

	if (par[strlen(par)-3]=='T') {	// if file is txt

		tftlcd_gotoxy(0,2);
  		while ((ch = fgetc (f)) != EOF) { 
		                           
			tftlcd_putchar(ch,BLACK,WHITE,1);
  		}
		tftlcd_puts("<EOF>",RED,WHITE,1);

	}else if (par[strlen(par)-3]=='M') {		// if file is MP3
	  
		//reserved for new version	

	}else if (par[strlen(par)-3]=='B')   { // if file is bmp
	
 		index=0;
		image_wi = 0;
		image_hi = 0;
		while ((ch = fgetc (f)) != EOF) { 
			index++;
			if (index == 11)  bmp_code_index = ch;
			else if (index == 19) image_wi += ch;
			else if (index == 20) image_wi |= (ch<<8);
			else if (index == 23) image_hi += ch; 
			else if (index == 24) image_hi |=(ch<<8);
			else if (index == 29) image_color = ch;
			else if (index == 30) {	// end reguire description . init LCD

				if (image_wi>240 | image_hi>320 | (image_color !=24 && image_color !=16)){
					tftlcd_gotoxy(0,1);	
					sprintf(buffer,"%i * %i 0x%xbit",image_wi,image_hi,image_color);
					tftlcd_puts(buffer,BLACK,RED,1);
					tftlcd_gotoxy(0,2);
					tftlcd_putsf("This Format Not Supported",BLACK,RED,1);
					return 0;
				}else {

					tftlcd_init_hispeed(0,image_wi-1,0,image_hi-1);
					TFTLCD_RS_HIGH;
				}	
			}else if (index>bmp_code_index){
				lcd_data = 0;
				if (image_color == 24) {
					lcd_data = (ch&0xF1)<<8;
					lcd_data |= (fgetc(f)&0xFC)<<4;
					lcd_data |= (fgetc(f))>>3;
				}else if (image_color == 16) {
					lcd_data = ch << 8;
					lcd_data |= fgetc(f);
				}
				TFTLCD_CS_LOW;
				TFTLCD_WR_LOW;
				TFTLCD_DATAPORT_CLEAR;
				_TFTLCD_DATAPORT_SODR_ = (lcd_data << TFTLCD_DATAPORT_OFFSET);
				TFTLCD_WR_HIGH;
				TFTLCD_CS_HIGH;	
			} 
		}
		sprintf(buffer,"%i * %i 0x%xbit",image_wi,image_hi,image_color);
		tftlcd_gotoxy(0,19);
		tftlcd_puts(buffer,BLACK,RED,1);	
	}
  	fclose (f); // close file                         
	return 1;

}


int main (void) {

	os_sys_init(task_init);
  	while (1);
}

__task	void  task_init(){


	AT91F_PIO_CfgOutput(AT91C_BASE_PIOB, AT91C_PIO_PB19 | AT91C_PIO_PB20);
	disp = Display();
	while (init_card ()==0) os_dly_wait(10);	

	os_tsk_create(task_main, 1);
	os_tsk_create(task_clock, 1);	
	os_tsk_delete_self();

}

__task	void  task_main(){

	List mylist("",List::Exclusive);
	Alert alert("File Explorer","By : Ramin Jafarpour",eca_image,Alert::OK);
	char *cmdtxt;
	char adress[50] = "M:\\*";
	char temp[50];
	char dip=0;
	os_dly_wait(300);

	disp.Show(alert);

	for (int i=0;i<10 && disp.cheak()==0 ;i++) 
		os_dly_wait(50); 

	os_dly_wait(10);


	while (1) {
		mylist = get_dir(adress); 
		disp.Show(mylist);
		while (1) {
			while ((cmdtxt = disp.cheak())==0) os_dly_wait(10);
			if (cmdtxt[strlen(cmdtxt)-4]=='.') {

				strcpy(temp,adress);
				temp[strlen(temp)-1]='\0';
				strcat(temp,cmdtxt);
				show_file(temp); //is file
				os_dly_wait(300);
			}

			else if (cmdtxt[strlen(cmdtxt)-1]=='<') { //back
				strcpy(adress,"");
				strcpy(adress,"M:\\*"); // goto root
				mylist = get_dir(adress);	
			}
			else { // is folder
				dip++;
				adress[strlen(adress)-1]='\0';
				strcat(adress,cmdtxt);
				strcat(adress,"\\*");
				mylist = get_dir(adress);
				mylist.Add("ROOT<<<",home_icon);
			} 
			disp.Show(mylist);
		}

	}

}

__task	void  task_clock(){

   os_itv_set(100);
   AT91F_PIO_ClearOutput(AT91C_BASE_PIOB, AT91C_PIO_PB20);
   while (1) {
   		os_itv_wait();
		AT91F_PIO_SetOutput (AT91C_BASE_PIOB, AT91C_PIO_PB19);
		os_itv_wait();
		AT91F_PIO_ClearOutput(AT91C_BASE_PIOB, AT91C_PIO_PB19);
   }

}
/*----------------------------------------------------------------------------
 * end of file
 *---------------------------------------------------------------------------*/
